# Monotone logistic B-spline fit with logit-, cloglog- and probit-link function
# library
library(splines)

# Function
additive.mpspline.fitter<-function(response=y,x.var=a,z.var=z,ps.intervals=20,degree=3,order=2,link="logit",
family="binomial",alpha=2,kappa=1e8)
{
	y <- response
	x <- x.var
	z <- z.var
	wts <- rep(1, length(y))
	q <- degree
	d <- order
	ndx <- ps.intervals
	m.binomial <- rep(1, length(y))
	n <- length(y)
	xl <- min(x)
	xr <- max(x)
	xmax <- xr + 0.01 * (xr - xl)
	xmin <- xl - 0.01 * (xr - xl)
	dx <- (xmax - xmin)/ndx
	knots <- seq(xmin - q * dx, xmax + q * dx, by = dx)
	b <- spline.des(knots, x, q + 1, 0 * x)$design
	n.col <- ncol(b)
	p <- sqrt(alpha)*diff(diff(diag(n.col)))
	mp <- sqrt(kappa)*diff(diag(n.col))
	nix <- rep(0, n.col - d)
	mnix <- rep(0, n.col - 1)
	b <- as.matrix(b)
	coef.est <- rep(1, ncol(b))
	ineqdiag<-diag(diff(coef.est)>=1e-9)
	if(family == "binomial") {
		mu <- (y + 0.5 * m.binomial)/2
	}
	it <- 0
	repeat {
		if(it == 0) {
			if(link == "logit") {
				eta <- log(mu/(m.binomial - mu))
			}
			if(link == "probit") {
				eta <- qnorm(mu/m.binomial)
			}
			if(link == "cloglog") {
				eta <- log( - log(1 - mu/m.binomial))
			}
		}
		it <- it + 1
		if(it > 100)
			break
		if(link == "logit") {
			mu <- m.binomial/(1 + exp( - eta))
			h.prime <- mu * (1 - mu/m.binomial)
		}
		if(link == "probit") {
			mu <- m.binomial * pnorm(eta)
			h.prime <- m.binomial * dnorm(eta)
		}
		if(link == "cloglog") {
			mu <- m.binomial * (1 - exp( - exp(eta+z)))
			h.prime <- (m.binomial) * exp(eta) * exp( - exp(eta))
		}
		if(family == "binomial") {
			w <- h.prime^2/(mu * (1 - mu/m.binomial))
		}
		u <- (y - mu)/h.prime + eta 
		f <- lsfit(rbind(b, p, ineqdiag%*%mp), c(u, nix, mnix), wt = c(wts, nix + 1, mnix + 1) *
			c(w, (nix + 1), (mnix + 1)), intercept = F)
		coef.old <- coef.est
		coef.est <- as.vector(f$coef)
		ineqdiag<-diag(diff(coef.est)<0)
		d.coef <- max(abs((coef.est - coef.old)/coef.old))
		if(d.coef < 1e-20)
			break
		#print(c(it, d.coef))
		eta <- b %*% coef.old 
	}
	w <- w*wts
	e <- 1e-009
	h <- hat(f$qr, intercept = F)[1:n]
	trace <- sum(h) - 1
	if(family == "binomial") {
		dev <- 2 * sum((y + e) * log((y + e)/(mu + e)) + (m.binomial - 
			y + e) * log((m.binomial - y + e)/(m.binomial - mu + e)
			))
		dispersion.parm <- 1
	}
	aic <- dev + 2 * trace
	bic <- dev + log(n) * trace
	x.seq <- seq(xl, xr, length = 50)
	b.seq <- spline.des(knots, x.seq, q + 1, 0 * x.seq)$design
	w.aug <- c(w, (nix + 1))
	yhat <- b %*% as.vector(coef.old) + z
	summary.yhat <- yhat
	if(link == "logit") {
		summary.yhat <- 1/(1 + exp( - summary.yhat))
	}
	if(link == "probit") {
		summary.yhat <- apply(summary.yhat, c(1, 2), pnorm)
	}
	if(link == "cloglog") {
		summary.yhat <- (1 - exp( - exp(summary.yhat)))
	}
 	return(list(x=x.seq,yhat=summary.yhat,aic=aic,bic=bic,dev=dev))
}